<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Utilisateur extends Model 
{

    protected $table = 'utilisateurs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_entreprise', 'name', 'email', 'matricule', 'passWord', 'telephone', 'photo', 'role', 'statut');
    protected $visible = array('slug', 'id_entreprise', 'name', 'email', 'matricule', 'passWord', 'telephone', 'photo', 'role', 'statut');

    public function entreprise()
    {
        return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
    }

    public function mouvementEffectif()
    {
        return $this->hasMany('App\Models\MouvementEffectif', 'id_utilisateur');
    }

    public function mouvementStock()
    {
        return $this->hasMany('App\Models\MouvementStock', 'id_utilisateur');
    }

    public function creanceDetteFond()
    {
        return $this->hasMany('App\Models\CreanceDetteFond', 'id_utilisateurNiveau4');
    }

    public function mailSms()
    {
        return $this->hasMany('App\Models\MailSms', 'id_utilisateur');
    }

    public function depense()
    {
        return $this->hasMany('App\Models\Depense', 'id_utilisateur');
    }

}